#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cassert>

#include <iostream>
#include <iomanip>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <deque>
#include <queue>
#include <stack>


#define forn(i, n) for(int i = 0; i < int(n); i++)
#define mp make_pair
#define pb push_back
#define foreach(it, v) for(__typeof(v.begin()) it = v.begin(); it != v.end(); ++it)

using namespace std;

typedef long long ll;

const int kMaxN = 310, kMaxC = 26;
const int kModulo = 1000000000;

int pathLength;
char path[kMaxN];
int ways[kMaxN][kMaxN];
bool splitUsed[kMaxN][kMaxN][kMaxC];
int splitWays[kMaxN][kMaxN][kMaxC];

inline int getSplit(int l, int r, int c) {
	assert(l <= r && c >= 0 && c < kMaxC);
	if(splitUsed[l][r][c]) return splitWays[l][r][c];
	splitUsed[l][r][c] = true;
	int result = ways[l][r];
	for(int i = l + 1; i < r; i++) {
		if(path[i] - 'A' == c) {
			ll resultBottom = (ways[l][i - 1] * getSplit(i + 1, r, c)) % kModulo;
			result += resultBottom;
			if(result >= kModulo)
				result -= kModulo;
		}
	}
	splitWays[l][r][c] = result;
	return result;
}

int main() {
	scanf("%s", path);
	pathLength = strlen(path);
	for(int i = 0; i < pathLength; i++)
		ways[i][i] = 1;
	for(int l = 3; l <= pathLength; l++) {
		for(int i = 0; i + l <= pathLength; i++) {
			int j = i + l - 1;
			if(path[i] == path[j]) {
				ways[i][j] = getSplit(i + 1, j - 1, path[i] - 'A');
			}
		}
	}
	int result = ways[0][pathLength - 1];
	printf("%d\n", result);
	return 0;
}